#!/usr/bin/perl -w
use strict;
use DBI;
use Carp;
use Term::ReadKey;
use lib "/home/dblock/work/Genquire";
use lib "..";
use GQ::Server::DB::DbObj;
use GQ::Server::DB::Context;

$SIG{'INT'}=\&Quit;

my $dbobj = getDbObj();
my $context = GQ::Server::DB::Context->new($dbobj);
my $dbh=$dbobj->dbh;

my @orgs=$context->all_orgs_by_id;
my %orgs;
print "Choose the id and version of the organism you would like to fix up:\n";
print join "\t\t",qw(latin common id version);
print "\n";
foreach (@orgs) {
    print $_->latin,"\t",$_->common,"\t",$_->id,"\t",$_->version,"\n";
    $orgs{$_->id}{$_->version}=$_;
}
chomp(my $org=<STDIN>);
chomp(my $ver=<STDIN>);
if (!exists $orgs{$org}{$ver}) {
    $context->rollback;
    $dbh->disconnect;
    exit;
} else {
    $context->organism($orgs{$org}{$ver});
}



# $struct is a hash of assembly ids, containing a list of contig names and their lengths,
# supposedly ordered by abs_start.  However, since there is no abs_start, the list is some
# random order, and we have to pull out the correct order.

# All we really need for now is the assembly id :)


my $sth=$dbh->prepare("SELECT name FROM Tiling_Path,ContigAssembly,Contig ".
		      "WHERE assembly=? AND Tiling_Path.contig_id=ContigAssembly.id AND ".
		      "Contig.id=ContigAssembly.contig_id AND fiveprime=''");

my $sth_overlap=$dbh->prepare("SELECT overlap5 from Tiling_Path where contig_id=?");

my $sth_get=$dbh->prepare("SELECT threeprime,length FROM Tiling_Path WHERE contig_id=?");

my $sth_set=$dbh->prepare("UPDATE Tiling_Path SET abs_start=? where contig_id=?");


while (1) {
    print "Which Chromosome? (0 to quit): ";
    chomp(my $chr=<STDIN>);
    last if !$chr;
    
    my $struct=$context->get_ordered_assemblies_by_chr($chr);
    
    foreach (keys %$struct) {  #there may be multiple assemblies within the chromosome
	$sth->execute($_);
	my ($first)=$sth->fetchrow_array;
	my $current=$first;
	my $as=1;
	while ($current) {
	    ($current, $as)=set_tp($current, $as);  # a recursing we will go!
	}
    }
    print "Tiling path for chromosome $chr constructed.\n\n";
}
undef $sth;
undef $sth_overlap;
undef $sth_get;
undef $sth_set;
$dbh->disconnect;
exit;



sub getDbObj {
    my ($user, $pass) = getUserAndPassword();
    my ($IP, $host, $port, $database) = getDatabaseSettings();
    return GQ::Server::DB::DbObj->new($user, $pass, $database, $IP);
}



sub getUserAndPassword {
    print "Enter your username: ";
    chomp(my $user=<STDIN>);
    print "Enter your password: ";
    ReadMode 'noecho';
    my $pass = ReadLine 0;
    chomp $pass;
    ReadMode 'normal';
    return ($user,  $pass);
    print "\n";
}


sub getDatabaseSettings {
    print "\nNow we need to know where the database is on the network.  If the database is on your\n";
    print "local machine, just hit enter.  Otherwise, enter the address of the mysql server host.\n";
    print "Mysql server address: ";
    chomp(my $IP=<STDIN>);
    my $host = $IP;
    my $port;
    if ($IP) {
	print "\nThank you.  What is the port mysql is listening on (default 3306)?\n";
	print "If you don't know, the default is probably fine.\n";
	print "Mysql port: [3306] ";
	chomp($port=<STDIN>);
	$IP .=":$port" if $port;
	$port = $port || "3306";
    }
    print "What is the name of your database?  [Default is \"genquire\"]\n";
    chomp(my $database=<STDIN>);
    $database = $database || "genquire";
    return ($IP, $host, $port, $database);
}

sub set_tp {
    my ($current,$as)=@_;
    my $cid=$context->get_contig_id($current);
    $sth_overlap->execute($cid);
    my ($overlap)=$sth_overlap->fetchrow_array;
    $as=$as-$overlap;
    $sth_set->execute($as,$cid);
    $context->commit;
    $sth_get->execute($cid);
    my ($next,$len)=$sth_get->fetchrow_array;
    $as = $as + $len;
    return ($next,$as);
}

sub Quit {
    $context->rollback;
    $dbh->disconnect;
    ReadMode 'normal';
    exit;
}
