%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_ascii2tmat(DSNL,cndN) converts ASCII ERP to binary ERP.
%:
%: The job constants are loaded from './_A_const.mat' <tcwt_help prm2mat>.
%: Then, the function iterates over DSNL reading and processing data from
%: the INPUT FILES and saving results to the corresponding OUTPUT FILES.
%:
%: FUNCTION ARGUMENTS
%:
%:   DSNL   DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%:
%:   cndN   A positive integer number denoting the experimental condition
%:          to which all trials in all ASCII files specified in DSNL belong.
%:
%: INPUT FILES               INPUT VARIABLES
%:
%:   ../_ascii/DSN.ASCIIext   ASCII matrix, vectorized or multiplexed
%:                            (see below)
%:
%: ASCIIext is a job input parameter <tcwt_help prm>.
%:
%: OUTPUT FILES              OUTPUT VARIABLES (for details, see below)
%:
%:   ../_tmat/DSN.t.mat       Verp,RIerp,CIerp
%:
%: INPUT ASCII DATA STRUCTURE
%:
%:   Vectorized:
%:
%:   v(1,1,1) v(1,1,2) v(1,1,3) ...  v(2,1,1) v(2,1,2) v(2,1,3) ...  ...
%:   v(1,2,1) v(1,2,2) v(1,2,3) ...  v(2,2,1) v(2,2,2) v(2,2,3) ...  ...
%:   v(1,3,1) v(1,3,2) v(1,3,3) ...  v(2,3,1) v(2,3,2) v(2,3,3) ...  ...
%:   ...
%:   ...
%:   ...
%:
%:   Multiplexed:
%:
%:   v(1,1,1)  v(1,2,1)  v(1,3,1) ...
%:   v(1,1,2)  v(1,2,2)  v(1,3,2) ...
%:   ...
%:   ...
%:   ...
%:
%:   v(2,1,1)  v(2,2,1)  v(2,3,1) ...
%:   v(2,1,2)  v(2,2,2)  v(2,3,2) ...
%:   ...
%:   ...
%:   ...
%:
%:   ...
%:   ...
%:   ...
%:
%: Notations used above:
%:
%:   v(N,K,M)  Voltage value corresponding to the Nth trial,
%:             Kth channel, and Mth time point.
%:
%: The ASCII-to-binary conversion is performed according
%: to the job input parameter isMultiplex <tcwt_help prm>.
%:
%: OUTPUT VARIABLES:     CIerp =
%:
%:                       [ time(1)   time(2)   time(3)   ... ]
%:
%:   RIerp =             Verp =
%:
%:   [ 0 cndN 1 ;        [ v(1,1,1)  v(1,1,2)  v(1,1,3)  ... ;
%:     0 cndN 2 ;          v(1,2,1)  v(1,2,2)  v(1,2,3)  ... ;
%:     ...      ;          ...                               ;
%:     ...      ;          ...                               ;
%:     ...      ;          ...                               ;
%:
%:     0 cndN 1 ;          v(2,1,1)  v(2,1,2)  v(2,1,3)  ... ;
%:     0 cndN 2 ;          v(2,2,1)  v(2,2,2)  v(2,2,3)  ... ;
%:     ...      ;          ...                               ;
%:     ...      ;          ...                               ;
%:     ...      ;          ...                               ;
%:
%:     ...      ;          ...                               ;
%:     ...      ;          ...                               ;
%:     ...      ]          ...                               ]
%:
%: Notations used above:
%:
%:   Verp      ERP matrix in the time domain
%:
%:   CIerp     Verp column index
%:
%:   RIerp     Verp row index
%:
%:   v(N,K,M)  Voltage value corresponding to the Nth trial,
%:             Kth channel, and Mth time point.
%:
%:   time(M)   Time (in seconds) corresponding to the Mth time point.
%:
%:   cndN      Condition (experimental condition denoted
%:             by a number), to which all trials in this file belong.

%       10        20        30        40        50        60        70        80

function tcwt_ascii2tmat(dsnl,cndN);

if ispc() pslash = '\'; else pslash = '/'; end
asciiPath = ['..' pslash '_ascii' pslash];
tmatPath  = ['..' pslash '_tmat'  pslash];

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_ascii2tmat: ASCII-to-Binary ERP Conversion\n')];
O=[O,tcwt_txt('------------------------------------------------------------------------------\n')];
load('_A_const.mat');
for n=1:size(dsnl,1)
 dsn = dsnl(n,:);
 dsnA = [asciiPath dsn '.' ASCIIext];
 dsnT = [tmatPath  dsn '.t.mat'];
 if exist(dsnT,'file')
  O=[O,tcwt_txt('%s: *.t.mat already exists\n' ,dsn)];
 else
  [Verp,RIerp,Ntrials,Nch] = tcwt_loadascii(dsnA,NtimePt,ChannelList,cndN,isMultiplex);
  CIerp = fullTime;
  O=[O,tcwt_txt('%s: trials: %u, channels: %u, time points: %u\n' ,dsn,Ntrials,Nch,NtimePt)];
  save(dsnT,'Verp','CIerp','RIerp');
 end
end
O=[O,tcwt_txt('------------------------------------------------------------------------------\n')];
O=[O,tcwt_txt('tcwt_ascii2tmat: Binary ERPs saved to *.t.mat\n')];
O=[O,tcwt_txt('______________________________________________________________________________\n')];


