%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_pc2cnd2ri(is1out,DSNL,Cnd,Nstd,MinGood) Multivariate Outlier Detection
%: from fixed principal components, separately for each experimental condition.
%:
%: The function iterates over DSNL reading and processing data from
%: the INPUT FILES and saving results to the corresponding OUTPUT FILES.
%: If is1out = 1, a second DSNLpool of 1out index names <tcwt_help ri2ri1out>
%: is created at each step, and the function iterates throuh DSNLpool.
%:
%: FUNCTION ARGUMENTS
%:
%:   is1out = 0 or 1; defines whether 1out indexes are used (see below)
%:
%:   DSNL     DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%:
%:   Cnd      List of experimental conditions <tcwt_help t2f>
%:
%:   Nstd     <tcwt_help f2pc>
%:
%:   MinGood  <tcwt_help f2pc>
%:
%: INPUT FILES               INPUT VARIABLES
%:
%:   ./DSN.f.mat              Verp,CIerp <tcwt_help t2f>
%:   ./DSN.pc.mat             pcTerp,pcEV <tcwt_help f2pc>
%:   ./DSN.ri1.mat            RIerp, DSNLpool <tcwt_help f2pool>
%:
%:  If is1out == 1
%:
%:   ./DSNp.out.DSN.ri1.mat   RIerp
%:
%: DSNp is taken from DSNLpool.
%:
%: OUTPUT FILES              OUTPUT VARIABLES
%:
%:   ./DSN.ri2.mat            RIerp, DSNLpool
%:   ./DSN.ri2.txt            Text output
%:
%:   If is1out == 1
%:
%:   ./DSNp.out.DSN.ri2.mat   RIerp, DSNLpool
%:   ./DSNp.1out.ri2.mat      Text output

%       10        20        30        40        50        60        70        80

function tcwt_pc2cnd2ri(is1out,dsnl,Cnd,Nstd,MinGood);

rin1='1';
rin2='2';

if (~isscalar(Nstd) || ~isnumeric(Nstd) || ~isreal(Nstd) || Nstd<2 )
 error('Invalid single-trial outlier detection criterion <tcwt_help f2pc>.');
end

if (~isscalar(MinGood) || ~isnumeric(MinGood) || ~isreal(MinGood) || MinGood<0 || MinGood>1 )
 error('Invalid dataset outlier detection criterion <tcwt_help f2pc>.');
end

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_pc2cnd2ri: Outlier Detection -- Done Separately for Each Condition:\n')];
O=[O,tcwt_txt('------------------------------------------------------------------------\n')];
headerO = O;
for n=1:size(dsnl,1)
 dsn=dsnl(n,:);
 load([dsn '.f.mat']);
 load([dsn '.pc.mat']);
 load([dsn '.ri' rin1 '.mat']);

 sVerp = Verp*pcTerp;

 if is1out
  dsnl_ri = tcwt_dsnl2xdsnl('',DSNLpool,['.out.' dsn]);
  txtExt = '.1out';
 else
  dsnl_ri = dsn; txtExt = '';
 end

 spaceS = repmat(' ',1,size(dsnl_ri,2));

 O=[O,tcwt_txt('%s Cond. SingleTrials DataSets   Cond. SingleTrials DataSets\n',spaceS)];
         % ?? |123: 1234(12.1%)  123(12.1%) |123: 1234(12.1%)  123(12.1%)
 for n_ri=1:size(dsnl_ri,1)
  dsn_ri=dsnl_ri(n_ri,:);
  load([dsn_ri '.ri' rin1 '.mat'])

  [RIerp,outlStr] = tcwt_pcoutlcnd(RIerp,sVerp,Cnd,Nstd,MinGood);
  O=[O,tcwt_txt('%s %s\n', dsn_ri,outlStr)];

  save([dsn_ri '.ri' rin2 '.mat'],'RIerp','DSNLpool');
 end
 tcwt_txtsave([dsn txtExt '.ri' rin2 '.txt'],O);
 O=headerO;
end
O=[O,tcwt_txt('________________________________________________________________________\n')];


