%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_ri2ri1out(poolNAME) creates 1out-indexes from the row index
%: of a pooled dataset excluding one individual dataset at a time.
%:
%: FUNCTION ARGUMENTS
%:
%:   poolNAME  The Name of the pooled dataset
%:
%: INPUT FILE                      INPUT VARIABLES
%:
%:   ./poolNAME.ri1.mat              RIerp,DSNLpool <tcwt_help f2pool>
%:
%: OUTPUT FILES                    OUTPUT VARIABLES
%:
%:   ./DSNp.out.poolNAME.ri1.mat     RIerp,DSNLpool
%:
%: DSNp is taken from DSNLpool.
%:
%: The function iterates over DSNLpool. At each iteration, DSNp is read
%: from the next row of DSNLpool and all trials belonging to the dataset
%: DSNp are marked as artifacts. RIerp, thus modified, is stored in the 
%: corresponding OUTPUT FILE.

%       10        20        30        40        50        60        70        80

function tcwt_ri2ri1out(poolName);

rin='1';

load([poolName '.ri' rin '.mat']);

poolRIerp=RIerp;
poolSout = logical(poolRIerp(:,1));
poolSbj = poolRIerp(:,3);

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_ri2ri1out: Creating 1-dataset-out-pooled Indices:\n')];
O=[O,tcwt_txt('------------------------------------------------------\n')];
O=[O,tcwt_txt('Pool Name: %s\n',poolName)];
O=[O,tcwt_txt('------------------------------------------------------\n')];
for nSbj=1:size(DSNLpool,1)
 dsn1out = DSNLpool(nSbj,:);
 dsn = [dsn1out '.out.' poolName];

 Ssbj = poolSbj==nSbj;
 RIerp(:,1) = uint32(( Ssbj | poolSout ) + 0);
 save([dsn '.ri' rin '.mat'],'RIerp','DSNLpool');
 O=[O,tcwt_txt('%s\n',dsn)];
end
O=[O,tcwt_txt('_______________________________________________________\n')];


