%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Discrete Fourier Transform (DFT) & Continuous Wavelet Transform (CWT)

function [fTerp,tTerp,cwTerp,logGrid] = tcwt_dftcwterp(Time,cutoffScale,logGridR,fadeInOut);

N = length(Time);
Ti = Time(1);
Tf = Time(N) + Time(2) - Time(1);

if ( ~isscalar(cutoffScale) || ~isnumeric(cutoffScale) || ~isreal(cutoffScale) || cutoffScale<=0 )
 error('Job input parameter cutoffScale must be a single positive number.');
end

if ( ~isscalar(logGridR) || ~isnumeric(logGridR) || ~isreal(logGridR) || ...
   logGridR~=round(logGridR) || logGridR<1 )
 error('Job input parameter logGridR must be a single positive integer number.');
end

if ( ~isrow(fadeInOut) || length(fadeInOut)~=2 || ~isnumeric(fadeInOut) || ~isreal(fadeInOut) || ...
   any(fadeInOut<0) )
 error('Job input parameter fadeInOut must be a row [t1 t2] with t1 and t2 both positive.');
elseif ( fadeInOut(1)+fadeInOut(2)>Time(N)-Time(1) )
 error('Job input parameter fadeInOut = [t1 t2] must fulfill: t1+t2 < Window(2)-Window(1).');
end

Nfreq = (Tf-Ti)/(cutoffScale/2);
maxFreq = floor(Nfreq);
if maxFreq>floor((N-1)/2)
 error('The value of the job input parameter cutoffScale is too small.')
end

[fTerp,tTerp] = tcwt_dft(N,maxFreq);
[cwTerp,logGrid] = tcwt_cwtdft(N,Nfreq,logGridR,tTerp,Ti,Tf);

fTerp = tcwt_wintukey(Time,fadeInOut) * fTerp * tcwt_ffilter(Nfreq);


