%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Detection of Extrema in the t-CWT scalogram

function [xTerp,xCIerp] = tcwt_xtcwt(tcwVerp,tcwCIerp,pcTerp,cwTerp);

xtrScale = 0.25; % scale parameter for extremum criterion; xtrScale = 0.25 has proved a good setting

C=tcwCIerp(1,:);
S=tcwCIerp(2,:);
T=tcwCIerp(3,:);
N=length(tcwVerp);
Cu=unique(C);
Nc=length(Cu);
Nst=N/Nc;
cwtIND=1:N;
stIND=repmat(1:Nst,1,Nc);

X = logical([0, abs(sign(diff(sign(diff(tcwVerp))))), 0]);
select = sign(abs(diff(S)));
select = logical([1,select]+[select,1]);
select = select | S==S(1) | S==S(N);
select = ~select & X;

xC=tcwCIerp(1,select);
xS=tcwCIerp(2,select);
xT=tcwCIerp(3,select);
xV=tcwVerp(select);
xI=cwtIND(select);
X=[];
for n=1:sum(select),
  d=xtrScale*xS(n);
  select = (xS-xS(n)-d/2).^2 + 2*(xT-xT(n)).^2 < (3*d/2)^2;
  select = select & xC==xC(n);
  Veps=xV(select);
  if isempty(Veps)
    continue
  elseif ( all(xV(n)>=Veps) || all(xV(n)<=Veps) )
    X=[X,xI(n)];
  end
end

xCIerp=[];
for xn=1:length(X),
  n=X(xn);
  d=xtrScale*S(n);
  select = (S-S(n)-d/2).^2 + 2*(T-T(n)).^2 < (3*d/2)^2 & cwtIND~=n;
  select = select & C==C(n);
  Veps=tcwVerp(select);
  if isempty(Veps)
    continue
  elseif all(tcwVerp(n)>Veps)
    xCIerp=[xCIerp, [C(n); S(n); T(n); 1; stIND(n); tcwVerp(n)]];
  elseif all(tcwVerp(n)<Veps)
    xCIerp=[xCIerp, [C(n); S(n); T(n);-1; stIND(n); tcwVerp(n)]];
  elseif all(tcwVerp(n)>=Veps)
    tcwVerp(n)=tcwVerp(n)+eps;
    xCIerp=[xCIerp, [C(n); S(n); T(n); 1; stIND(n); tcwVerp(n)]];
  elseif all(tcwVerp(n)<=Veps)
    tcwVerp(n)=tcwVerp(n)-eps;
    xCIerp=[xCIerp, [C(n); S(n); T(n);-1; stIND(n); tcwVerp(n)]];
  end
end

Nd=size(cwTerp,1);
xTerp=[];
if ~isempty(xCIerp)
  for c=Cu,
    cwTerpIND=xCIerp(5,xCIerp(1,:)==c);
    if isempty(cwTerpIND)
      xTerp = blkdiag(xTerp, zeros(Nd,0));
    else
    % xTerp = blkdiag( xTerp, cwTerp(:,cwTerpIND) );
      xTerp = blkdiag( xTerp, cwTerp(:,cwTerpIND) * diag(tcwVerp(cwTerpIND)) );
    end
  end
end

xTerp = (pcTerp*pcTerp')*xTerp;


