%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Discrete Fourier Transform (DFT) for real vectors.
%: Truncated at the Cutoff Frequency "maxFreq".

function [fTerp,tTerp] = tcwt_dft(N,maxFreq);

fTerp=fft(eye(N)); % DFT matrix: fft(eye(N)) == fft(eye(N)).'
constTerp = fTerp(:,1);
cosTerp =  sqrt(2)*real( fTerp(:, 2:1+maxFreq ) );
sinTerp = -sqrt(2)*imag( fTerp(:, 2:1+maxFreq ) );

fTerp = [constTerp, cosTerp, fliplr(sinTerp)]/sqrt(N);
tTerp=[fTerp; fTerp(1,:)]'; % Inverse DFT matrix: 1 Time Point added


