%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: INTRODUCTION TO t-CWT: The Eightfold Path
%:
%: 1. Read this introduction, then download and assess the example ERP data
%:    <tcwt_help example> to get a first impression of how t-CWT works.
%:    Then, create your own project following the steps below.
%:
%: 2. Choose a new project name (prjNAME) and make a directory
%:    tcwtWORK/prjNAME (Here and further, tcwtROOT and tcwtWORK denote
%:    the t-CWT root path and the t-CWT work path <tcwt_help install>.)
%:
%: 3. Perform EOG correction, technical artifact rejection, segmentation and
%:    binary-to-ASCII conversion of your ERP data with some other software,
%:    and save the obtained ASCII datasets to tcwtWORK/prjNAME/_ascii.
%:
%: 4. Choose a new job input parameter file name (prmNAME) and copy
%:    the demo job input parameter file tcwtROOT/demo/tcwt_prm.m to
%:    tcwtROOT/jobs/prjNAME_prmNAME.m <tcwt_help prm>. Then, open
%:    prjNAME_prmNAME.m with an appropriate text editor and make the
%:    necessary changes. For instance, set ASCIIext, isMultiplex, the
%:    analog-to-digital time-sampling rate a2dR, etc. according to the
%:    results from the binary-to-ASCII conversion <tcwt_help ascii2tmat>.
%:
%: 5. Choose a new job input variable file name (varNAME) and copy
%:    the demo job input variable file tcwtROOT/demo/tcwt_var.m to
%:    tcwtROOT/jobs/prjNAME_varNAME.m <tcwt_help var>. Then, open
%:    prjNAME_varNAME.m and make the necessary changes. Change, e.g.,
%:    the PCA criteria, the outlier criteria, etc. <tcwt_help f2pc>.
%:
%: 6. Choose a new job script file name (scrNAME) and copy
%:    the demo job script file tcwtROOT/demo/tcwt_scr.m to
%:    tcwtROOT/jobs/prjNAME_scrNAME.m <tcwt_help scr>. Then,
%:    open prjNAME_scrNAME.m and make changes, if necessary.
%:
%: 7. Copy the demo main script file tcwtROOT/demo/tcwt_scr_prm_var.m to
%:    tcwtROOT/jobs/prjNAME_scrNAME_prmNAME_varNAME.m and then just run
%:    prjNAME_scrNAME_prmNAME_varNAME with MATLAB or with GNU Octave, either
%:    in interactive mode, or from the command line, or from a shell script,
%:    e.g.: matlab -r "myprj_scr_prm_var" -logfile myprj_scr_prm_var.log
%:    or:   octave --eval "myprj_scr_prm_var" &> myprj_scr_prm_var.log
%:    The main script extracts scrNAME, prmNAME, and varNAME from its own
%:    name, calls the corresponding scripts and saves the results of their
%:    execution in the directory tcwtWORK/prjNAME/prmNAME_varNAME (which is
%:    newly created by the main script, if it does not exist).
%:
%: 8. In order to view the results from the t-CWT assessment of your ERP
%:    data, open the file tcwtWORK/prjNAME/prmNAME_varNAME/_A_run_scrNAME.log

%       10        20        30        40        50        60        70        80

tcwt_help intro